### 73.8. 使用Ant构建可执行存档（archive）

想要使用Ant进行构建，你需要抓取依赖，编译，然后像通常那样创建一个jar或war存档。为了让它可以执行：

1. 使用合适的启动器配置`Main-Class`，比如对于jar文件使用JarLauncher，然后将其他需要的属性以manifest实体指定，主要是一个`Start-Class`。
2. 将运行时依赖添加到一个内嵌的'lib'目录（对于jar），`provided`（内嵌容器）依赖添加到一个内嵌的`lib-provided`目录。记住***不要***压缩存档中的实体。
3. 在存档的根目录添加`spring-boot-loader`类（这样`Main-Class`就可用了）。

示例：
```xml
<target name="build" depends="compile">
    <copy todir="target/classes/lib">
        <fileset dir="lib/runtime" />
    </copy>
    <jar destfile="target/spring-boot-sample-actuator-${spring-boot.version}.jar" compress="false">
        <fileset dir="target/classes" />
        <fileset dir="src/main/resources" />
        <zipfileset src="lib/loader/spring-boot-loader-jar-${spring-boot.version}.jar" />
        <manifest>
            <attribute name="Main-Class" value="org.springframework.boot.loader.JarLauncher" />
            <attribute name="Start-Class" value="${start-class}" />
        </manifest>
    </jar>
</target>
```
该Actuator示例中有一个build.xml文件，可以使用以下命令来运行：
```shell
$ ant -lib <path_to>/ivy-2.2.jar
```
在上述操作之后，你可以使用以下命令运行该应用：
```shell
$ java -jar target/*.jar
```
